### Hessian-Aware Training for Enhancing DNNs Resilience to Parameter-level Variations

This repository contains the code for training a model with our "Hessian-Aware training"

----

### TL; DR

We propose hessian-aware training, a novel method that significantly enhances the resilience of deep neural networks to parameter-level variations

----

#### Abstract

Deep neural networks are not resilient to parameter perturbations: small corruptions in their parameters can lead to significant performance degradation. This susceptibility poses great challenges in deploying them on emerging computing platforms, such as in-memory computing devices, where frequent bitwise errors occur. Most prior work addresses this issue with hardware or system-level approaches, such as additional hardware components for checking a model's integrity at runtime. However, these methods have not been widely deployed since they necessitate substantial infrastructure-wide modifications. In this paper, we study a new approach to address this challenge: we present a novel training method aimed at enhancing a model's resilience to parameter corruptions. We define a *model-sensitivity* metric to measure this resilience and propose a training algorithm with an objective of minimizing the sensitivity. Models trained with our method demonstrate increased resilience to parameter perturbations, particularly with a 50% reduction in parameters whose corruption leads to a 90-100% accuracy drop. Our method also aids in extreme model compression, such as lower bit-width quantization or pruning ~70% of parameters, with reduced performance loss. Moreover, our method is compatible with existing strategies to mitigate this susceptibility.

----

### Pre-requisites

Clone this source code to your local machine and run the environmental setup:

```
$ git clone https://github.com/Tahmid1406/DABF-model-level-defense.git
$ pip install -r requirements.txt
```

--- 

### Train A Model Using Hessian-aware Training

You can simply run the following command:

```
$ python3 train.py [list of arguments to be added here]
```

Here are the arguments that you can pass from the command line. Please feel free to modify:

```
--seed = random seed
--cuda = enables CUDA training
--num-workers = number of workers
--pin-memory = the data loader copies tensors into CUDA pinned memory
--dataset = dataset used to train
--datapth = dataset location
--augment = data augmentation method
--network = model name
--trained = pre-trained model filepath
--lossfunc = loss function name for this task 
--classes = number of classes in the dataset
--batch-size = input batch size for training
--epoch = number of epochs to train
--optimizer = optimizer used to train
--lr = learning rate
--hessLR = learning rate 
--schedule = adjust learning rate at each specific epoch
--adaHessian = enables training with adahessian optimizer
--hessLR = set the value for lamda
```

**Thx**
